package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGConnecting {

	/**
	 * Demonstrates basics of connecting to a running  server
	 * 
	 * You will need to start the server before running examples.
	 * 
	 * $ ./AllegroGraphServer
	 * 
	 * Please see "Starting A Server Manually" in the Learning Center for more information.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to the default server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			// This example connects to a server on the default port.
			// For servers listening on a non-default port, e.g. 4126,
			// uncomment this to specify the port:
			//ags.setPort(4126);
			System.out.println("Attempting to connect to the server on port " + ags.getPort());
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem -- please ensure the server is running.", e);
		}

		System.out.println("Connection enabled.");
		
		// Disconnect from the server
		System.out.println("Disconnecting from the server.");
		ags.disable();
		System.out.println("Done.");
		
	}
	
}
