package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGCreatingTriples {

	/**
	 * Demonstrates some basics of creating triples from triple parts.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("creatingtriples", AGPaths.TRIPLE_STORES);
		
		// Create a triple from parts in N-Triples format and add it to the store
		// but don't return the triple
		ts.addStatement("<http://example.org/Dog>",  
				"<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>",  
				"<http://www.w3.org/2002/07/owl#Class>"); 

		// Create a triple from parts in N-Triples format and add it to the store
		// and return the triple
		Triple tr = ts.newTriple("<http://example.org/Dog>",
				"<http://www.w3.org/2000/01/rdf-schema#subClassOf>",
				"<http://example.org/Mammal>"); 
		
		System.out.println("Created and added the following triple to the store:");
		AGUtils.showTriple(tr);
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
}
