package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGFederationFreetextSearch {

	/**
	 * Demonstrates freetext search in a federation of triple stores.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to the default server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem.", e);
		}

		// Create triple stores for this example
		AllegroGraph ts1 = ags.renew("store1", AGPaths.TRIPLE_STORES);
		AllegroGraph ts2 = ags.renew("store2", AGPaths.TRIPLE_STORES);
		
		// Create a federated store consisting of the first 2 open stores above 
		AllegroGraph[] parts = {ts1,ts2};
		AllegroGraph fed = ags.federate("federationfreetext", parts, true);
		
		// Register a namespace
		// You must register with the base stores, not the federation.
		ts1.registerNamespace("ex", "http://example.org/");
		ts2.registerNamespace("ex", "http://example.org/");
		
		// Register any predicates whose objects are to be searched
		// You must register with the base stores, not the federation.
		ts1.registerFreetextPredicate("<http://www.w3.org/2000/01/rdf-schema#comment>");
		ts2.registerFreetextPredicate("<http://www.w3.org/2000/01/rdf-schema#comment>");
		
		// Add some triples to the store
		ts1.addStatement("!ex:jans", "!rdfs:comment", "\"Born in Emmen in the Netherlands\"");
		ts2.addStatement("!ex:gary", "!rdfs:comment", "\"Born in Springfield in the USA\"");
		ts2.addStatement("!ex:henk", "!rdfs:label", "\"Born in Emmermeer in the Netherlands\"");
		
		// Search the federation for subjects whose object contains emmen and born
		ValueSetIterator it = fed.getFreetextUniqueSubjects("(and 'emmen' 'born')");
		System.out.println("Subjects matching search: (and 'emmen' 'born')");
		AGUtils.showResults(it);
		
		// Search the federation for statements whose object contains emmen and born
		TriplesIterator cc = fed.getFreetextStatements("(and 'emmen' 'born')");
		AGUtils.showTriples(cc);
				
		// Close all stores and disconnect from the server
		fed.closeTripleStore();
		ts1.closeTripleStore();
		ts2.closeTripleStore();
		ags.disable();
	}
	
}
