package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGFederationRangeQueries {

	/**
	 * Demonstrates a range query on a federated store. 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
	
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Register your namespaces
		ags.registerNamespace("ex","http://example.org/");
		
		// Create triple stores
		AllegroGraph ts1 = ags.renew("store1", AGPaths.TRIPLE_STORES);
		AllegroGraph ts2 = ags.renew("store2", AGPaths.TRIPLE_STORES);

		// Create a federated store consisting of the first 2 open stores above 
		AllegroGraph[] parts = {ts1,ts2};
		AllegroGraph fed = ags.federate("federation", parts, true);
		
		// Populate the leaf stores
		// Encoded literals are necessary when performing range queries 
		ts1.addStatement("!ex:person1","!ex:age", ts1.createEncodedLiteral(28,"int"));
		ts1.addStatement("!ex:person2","!ex:age", ts1.createEncodedLiteral(30,"int"));
		ts1.addStatement("!ex:person3","!ex:age", ts1.createEncodedLiteral(32,"int"));
		ts2.addStatement("!ex:person4","!ex:age", ts2.createEncodedLiteral(40,"int"));
		ts2.addStatement("!ex:person5","!ex:age", ts2.createEncodedLiteral(42,"int"));
		
		// Retrieve triples by matching a range of objects
		EncodedLiteral low = fed.createEncodedLiteral(30,"int");
		EncodedLiteral high = fed.createEncodedLiteral(40,"int");
		System.out.println("Retrieving triples with range 30 <= ex:age <= 40");
		TriplesIterator it = fed.getStatements(null, "!ex:age", low, high, null, null);
		AGUtils.showTriples(it);

		// Close the triple store and disconnect from the server
		fed.closeTripleStore();
		ts2.closeTripleStore();
		ts1.closeTripleStore();
		ags.disable();
	}

}
