package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGGeospatialSubtypes {

	/**
	 * Demonstrates how to register new Geospatial subtypes with a store and
	 * how to obtain the existing subtypes.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple-store.
		AllegroGraph ts = ags.renew("geospatialsubtypes", AGPaths.TRIPLE_STORES);
		
		// Get a GeoExtension instance for this store to work with geospatial features 
		GeoExtension geo = ts.getGeoExtension();
		
		// Register several Geospatial subtypes with the store
		GeospatialSubtype subtype1 = geo.registerCartesianStriping(0, 1, 0, 1, .01);
		geo.addSubtype(subtype1);
		GeospatialSubtype subtype2 = geo.registerLatitudeStripingInDegrees(3);
		geo.addSubtype(subtype2);
		GeospatialSubtype subtype3 = geo.registerLatitudeStripingInKm(50);
		geo.addSubtype(subtype3);
		GeospatialSubtype subtype4 = geo.registerLatitudeStripingInMiles(5);
		geo.addSubtype(subtype4);
		
		// Obtain the subtypes that are registered with the store
		GeospatialSubtype subtype[] = geo.getSubtypes();
		for (int i=0;i<subtype.length;i++) {
			System.out.println(subtype[i]);
		}
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
