package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGGetStatements {

	/**
	 * Demonstrates some basics of retrieval by matching triple parts. 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
	
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("getstatements", AGPaths.TRIPLE_STORES);

		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!ex:p", "!ex:b");
		ts.addStatement("!ex:p","!rdfs:domain", "!ex:D");
		ts.addStatement("!ex:p","!rdfs:range", "!ex:R");
		
		// Retrieve triples by matching subject
		TriplesIterator cc = ts.getStatements(false,"!ex:a",null,null);
		System.out.println("Retrieving triples with subject ex:a");
		AGUtils.showTriples(cc);

		// Retrieve triples by matching predicate
		cc = ts.getStatements(false,null,"!rdfs:domain",null);
		System.out.println("Retrieving triples with predicate rdfs:domain");
		AGUtils.showTriples(cc);

		// Retrieve triples by matching object
		cc = ts.getStatements(false,null,null,"!ex:b");
		System.out.println("Retrieving triples with object ex:b");
		AGUtils.showTriples(cc);

		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
