package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGNCIThesaurus {

	/**
	 * Demonstrates loading and indexing of the NCI Thesaurus, available for
	 * download at:
	 * 
	 * ftp://ftp1.nci.nih.gov/pub/cacore/EVS/NCI_Thesaurus/
	 * 
	 * This example assumes that the data will be unzipped into a file
	 * Thesaurus.owl in the AGPaths.DATA_SOURCES directory; modify this
	 * location as necessary.
	 *   
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create fresh triple-store.
		AllegroGraph ts = ags.renew("NCIThesaurus", AGPaths.TRIPLE_STORES);

		// Load the NCI Thesaurus dataset
		AGLoadRDF.loadRDFWithTiming(ts,AGPaths.dataSources("Thesaurus.owl"));

		// Index the store for faster querying
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
	
}
