package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlBlankNodeLabels {

	/**
	 * Demonstrates some basics of blank node labels in SPARQL
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparql", AGPaths.TRIPLE_STORES);
				
		// Register the foaf namespace
		ts.registerNamespace("foaf", "http://xmlns.com/foaf/0.1/");
		
		// Define blank nodes
		BlankNode a = (BlankNode)ts.createBNode("_:a");
		BlankNode b = (BlankNode)ts.createBNode("_:b");
		
		// Add some data to the store
		ts.addStatement(a,"!foaf:name",ts.createLiteral("Alice"));
		ts.addStatement(b,"!foaf:name",ts.createLiteral("Bob"));

		// A query showing blank node labels
		String query =
		"PREFIX foaf:   <http://xmlns.com/foaf/0.1/> " +
		"SELECT ?x ?name " +
		"WHERE  { ?x foaf:name ?name }";
		
		// Query the store and show the results
		// Note that the labels on blank nodes can be different than
		// those supplied above.  There need not be any relation 
		// between a label _:a in the result set and a blank node 
		// in the data graph with the same label.
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}