package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlFreetextSearch {

	/**
	 * Demonstrates freetext search using the fti:match predicate in SPARQL. 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("kennedy", AGPaths.TRIPLE_STORES);

		// Register any predicates whose objects are to be searched
		ts.registerFreetextPredicate("<http://example.org/kennedy/first-name>");
		
		// Load the Kennedy data
		AGLoadNtriples.loadNTriplesWithTiming(ts,AGPaths.dataSources("kennedy.ntriples"));
		
		// Index the store for querying, wait until indexing is complete.
		ts.indexAllTriples(true);

		// This query looks at triples involving registered freetext 
		// predicates for ?persons whose objects contain Arnold
		String query =
		"PREFIX ex: <http://example.org/kennedy/> " +
		"PREFIX fti: <http://franz.com/ns/allegrograph/2.2/textindex/>" + 
		"SELECT ?fname ?lname " +
		"WHERE { ?person fti:match 'Arnold' . " +
				"?person ex:first-name ?fname . " +
				"?person ex:last-name ?lname " +
				"}";
		
		// Query the store and show the results
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// 
		query =
		"PREFIX ex: <http://example.org/kennedy/> " +
		"PREFIX fti: <http://franz.com/ns/allegrograph/2.2/textindex/>" + 
		"SELECT ?person1 ?person2 " +
		"WHERE { ?person1 fti:match 'John' . " +
				"?person2 ex:has-parent ?person1 . " +
				"}";
		
		// Query the store and show the results
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
