package com.franz.agbase.examples;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.EncodedLiteral;
import com.franz.agbase.TriplesIterator;

public class AGTemporalDateTime {

	/**
	 * Demonstrates some basics of working with date-time objects.
	 * 
	 * @param unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {

		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("datetime", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		EncodedLiteral lit = ts.createEncodedLiteral("2000-01-01T00:00:00-00:00","date-time");
		AGUtils.showLiteral(lit);
		ts.addStatement("!ex:person1","!ex:birthdate", lit);
		TriplesIterator it = ts.getStatements(null, "!ex:birthdate", lit);
		AGUtils.showTriples(it);
		
		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
		
	}

}
