package com.franz.agjena.examples;



import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.franz.agjena.AllegroGraphModel;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;

public class AGJenaQueryAllGraphs {

	/**
	 * Demonstrates using the Graph of all graphs. 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("jenatest5", AGPaths.TRIPLE_STORES);

		// Create a Graph maker for the store
	    AllegroGraphGraphMaker maker = new AllegroGraphGraphMaker(ts);
	    
	    // Set the default graph behavior to the graph of all graphs
        maker.setDefaultIsGraphOfAllGraphs(true);
	    
        // Create a named graph and model
        String demoNamespace = "http://ag.franz.com/demo#";
        String graphName1 = demoNamespace + "context1";
        Graph graphOne = maker.createGraph(graphName1);
        Model modelOne = new AllegroGraphModel(graphOne);

        // Load some data into the named graph
        String inputFileName1 = AGPaths.dataSources("vc-db-1.rdf");
        modelOne.read(inputFileName1, "RDF/XML" );
        
        // Query the default graph
        String query = "select ?s ?p ?o where {?s ?p ?o }";
        AGJenaUtils.doQuery(query, maker.getGraph());
 
	    // Set the default graph behavior to just the default graph
        maker.setDefaultIsGraphOfAllGraphs(false);
	    
        // Query the default graph again
        query = "select ?s ?p ?o where {?s ?p ?o }";
        AGJenaUtils.doQuery(query, maker.getGraph());
 
        // Close the store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
