
// ***** BEGIN LICENSE BLOCK *****
// Version: MPL 1.1
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// The Original Code is the AllegroGraph Java Client interface.
//
// The Original Code was written by Franz Inc.
// Copyright (C) 2006 Franz Inc.  All Rights Reserved.
//
// ***** END LICENSE BLOCK *****

package com.franz.ag.impl;

import org.openrdf.model.GraphException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.StatementIterator;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.ResourceNode;

/**
 * This intermediate class implements the methods in the 
 * interface defined by org.openrdf.model.Resource.
 */
public abstract class ResourceNodeImpl extends ValueNodeImpl implements Resource, ResourceNode
{

	protected ResourceNodeImpl () { super(); }
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2007686642441824762L;

	public void addProperty(URI property, Value value)
		throws GraphException {
		try {
			owner.addStatement(this, property, value);
		} catch (AllegroGraphException e) {
			throw new GraphException(e);
		}
	}	

	public StatementIterator getSubjectStatements()
		throws GraphException {
		try {
			return owner.getStatements(this, null, null);
		} catch (AllegroGraphException e) {
			throw new GraphException(e);
		}
	}

}

